//
//  GHSyncConstants.h
//  Garmin Health
//
//  Created by Rozum, Tim on 2/18/14.
//  Copyright (c) 2014 Garmin International, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *const GHSyncErrorDomain;
/** Count of files that failed to parse. */
extern NSString *const GHSyncErrorFileCountKey;

/**
 *  Sync errors.
 */
typedef NS_ENUM(NSInteger, GHSyncError) {
    /** Unexpected error */
    GHSyncErrorUndefined = 0,
    
    /** Timed out when starting or processing sync */
    GHSyncErrorAppTimeout = 1,
    
    /** Device was disconnected or otherwise terminated connection */
    GHSyncErrorDevice = 2,
    
    /** Device not valid and failed to respond to information request */
    GHSyncErrorInvalidUnitID = 3,
    
    /** Error transferring ConnectIQ data */
    GHSyncErrorNoSlotsForFileType = 4,
    
    /** Error transferring ConnectIQ data */
    GHSyncErrorNotEnoughSpaceForFileType = 5,
    
    /** One or more files failed to parse */
    GHSyncErrorFileParse = 6,
    
    /** Unable to open a file */
    GHSyncErrorFileOpen = 7
};

